<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\admin\RoleController;
use App\Http\Controllers\admin\UserController;
use App\Http\Controllers\admin\SettingsController;
use App\Http\Controllers\admin\PartnerController;
use App\Http\Controllers\admin\DriverController;
use App\Http\Controllers\admin\VendorController;
use App\Http\Controllers\admin\FareController;
use App\Http\Controllers\admin\BookingController;
use App\Http\Controllers\Auth\LoginController;

Route::get('/control-panel', function () {
    return view('auth.login');
});

Route::get('/', function () {
    return view('index');
});
 
Route::get('/vendor', function () {
    return view('vendors.login');
})->name('vendor-login');



Route::get('/driver', function () {
    return view('drivers.login');
})->name('driver-login');

Auth::routes();
  
 
Route::group(['middleware' => ['auth']], function() {
    Route::resource('roles', RoleController::class);
    Route::resource('users', UserController::class);
  
    Route::get('/home', function () {
        return view('home');
    })->name('home');


    // ******************* zone section start ***************
      Route::get('/zones', function () {
    return view('zones');
    })->name('zones');

          Route::get('/add/zone', function () {
    return view('add-zone');
    })->name('add-zone');

    Route::post('/add/zone', [SettingsController::class, 'addZone'])->name('add-zone');
    Route::get('/get/zone', [SettingsController::class, 'getZone'])->name('get-zone');
     Route::post('/edit/zone', [SettingsController::class, 'editZone'])->name('edit-zone');
    Route::get('/delete/zone/{id}', [SettingsController::class, 'deleteZone'])->name('delete-zone');
    // ******************* zone section end ***************

    // ******************* vehicleCategory section start ***************
      Route::get('/Vehicle/Categories', function () {
    return view('vehicleCategory');
    })->name('vehicleCategory');
    Route::post('/add/vehicleCategory', [SettingsController::class, 'addvehicleCategory'])->name('add-vehicleCategory');
    Route::get('/get/vehicleCategory', [SettingsController::class, 'getvehicleCategory'])->name('get-vehicleCategory');
    Route::post('/edit/vehicleCategory', [SettingsController::class, 'editvehicleCategory'])->name('edit-vehicleCategory');
    Route::get('/delete/vehicleCategory/{id}', [SettingsController::class, 'deletevehicleCategory'])->name('delete-vehicleCategory');
    // ******************* vehicleCategory section send ***************

     // ******************* partner section start ***************
      Route::get('/partners', function () {
    return view('partner');
    })->name('partners');
    Route::post('/add/partner', [PartnerController::class, 'addpartner'])->name('add-partner');
    Route::get('/get/partner', [PartnerController::class, 'getpartner'])->name('get-partner');
     Route::post('/edit/partner', [PartnerController::class, 'editpartner'])->name('edit-partner');
    Route::get('/delete/partner/{id}', [PartnerController::class, 'deletepartner'])->name('delete-partner');
    // ******************* partner section end ***************

    // ******************* driver section start ***************
      Route::get('/drivers', function () {
    return view('driver.list');
    })->name('drivers');
    Route::get('/add/driver', function () {
    return view('driver.add');
    })->name('add-driver');
    Route::post('/add/driver', [DriverController::class, 'adddriver'])->name('add-driver');
    Route::get('/get/driver', [DriverController::class, 'getdriver'])->name('get-driver');
     Route::get('/edit/driver/{id}', [DriverController::class, 'editdriver'])->name('edit-driver');
      Route::post('/update/driver', [DriverController::class, 'updatedriver'])->name('update-driver');
    Route::get('/delete/driver/{id}', [DriverController::class, 'deletedriver'])->name('delete-driver');
    // ******************* driver section end ***************

    // ******************* vendor section start ***************
      Route::get('/vendors', function () {
    return view('vendor.list');
    })->name('vendors');
    Route::get('/add/vendor', function () {
    return view('vendor.add');
    })->name('add-vendor');
    Route::post('/add/vendor', [VendorController::class, 'addvendor'])->name('add-vendor');
    Route::get('/get/vendor', [VendorController::class, 'getvendor'])->name('get-vendor');
     Route::get('/edit/vendor/{id}', [VendorController::class, 'editvendor'])->name('edit-vendor');
      Route::post('/update/vendor', [VendorController::class, 'updatevendor'])->name('update-vendor');
    Route::get('/delete/vendor/{id}', [VendorController::class, 'deletevendor'])->name('delete-vendor');
    // ******************* vendor section end ***************

    
    // ******************* vehicle section start ***************
      Route::get('/vehicles', function () {
    return view('vehicle.list');
    })->name('vehicles');
    Route::get('/add/vehicle', function () {
    return view('vehicle.add');
    })->name('add-vehicle');
    Route::post('/save/vehicle', [DriverController::class, 'savevehicle'])->name('save-vehicle');
    Route::get('/get/vehicle', [DriverController::class, 'getvehicle'])->name('get-vehicle');
        Route::get('/delete/vehicle/image/{id}/{image}', [DriverController::class, 'deletevehicleImage'])->name('delete-image');
     Route::get('/edit/vehicle/{id}', [DriverController::class, 'editvehicle'])->name('edit-vehicle');
      Route::post('/update/vehicle', [DriverController::class, 'updatevehicle'])->name('update-vehicle');
    Route::get('/delete/vehicle/{id}', [DriverController::class, 'deletevehicle'])->name('delete-vehicle');
    // ******************* vehicle section end ***************

    // ******************* brandmodel section start ***************
      Route::get('/brands', function () {
    return view('brands');
    })->name('brands');
        Route::post('/add/brand/model', [SettingsController::class, 'addbrandmodel'])->name('add-brand-model');
    Route::post('/add/brand', [SettingsController::class, 'addbrand'])->name('add-brand');
    Route::get('/get/brandmodel', [SettingsController::class, 'getbrandmodel'])->name('get-brandmodel');
     Route::post('/edit/brandmodel', [SettingsController::class, 'editbrandmodel'])->name('edit-brandmodel');
    Route::get('/delete/brandmodel/{id}', [SettingsController::class, 'deletebrandmodel'])->name('delete-brandmodel');
    Route::get('/settings', function () {
    return view('settings');
    })->name('settings');
        Route::post('/update/settings', [SettingsController::class, 'updatesettings'])->name('update-settings');
    // ******************* brandmodel section end ***************


      
    // ******************* fare section start ***************
      Route::get('/fare', function () {
    return view('fare.list');
    })->name('fare');
    Route::get('/add/fare', function () {
    return view('fare.add');
    })->name('add-fare');
    Route::post('/add/fare', [FareController::class, 'addfare'])->name('add-fare');
    Route::get('/get/fare', [FareController::class, 'getfare'])->name('get-fare');
     Route::get('/edit/fare/{id}', [FareController::class, 'editfare'])->name('edit-fare');
      Route::post('/update/fare', [FareController::class, 'updatefare'])->name('update-fare');
    Route::get('/delete/fare/{id}', [FareController::class, 'deletefare'])->name('delete-fare');
    // ******************* fare section end ***************

     // ******************* booking section  ***************
     Route::controller(BookingController::class)->group(function(){    
       Route::get('/bookings', function () {
        return view('booking.list');
        })->name('bookings');
                Route::get('/get/bookings', 'getBookings')->name('get-bookings');
                 Route::post('/assign/driver', 'assignDriver')->name('assign-driver'); 
                Route::get('/get/booking/details', 'getBookingDetails')->name('get-booking-details');        
                Route::get('/delete/booking/{id}', 'deletebooking')->name('delete-booking');
           });
 // ******************* booking section end ***************
     Route::get('/test', function () {
    return view('test');
    })->name('test');
  Route::post('/calculate-fare', [FareController::class, 'calculateFare']);
  });

 Route::prefix('vendor')->as('vendor.')->group(function () {

    // LoginController routes (public)
    Route::controller(LoginController::class)->group(function(){
        Route::post('send-otp','sendOtp')->name('send-otp');
        Route::post('verify-otp','verifyOtp')->name('verify-otp');
        Route::get('/verify-phone', 'verifyPhone')->name('verify.phone');
        Route::get('/not-active', function () {
            return view('vendors.not-active');
        })->name('not-active');
    });

    // Protected vendor routes
    Route::middleware('vendor')->group(function () {
        Route::get('/dashboard', function () {
            return view('vendors.dashboard');
        })->name('dashboard');
    });

});

Auth::routes();

